/******************************************************************************
* This file contains the declarations for different data used in FSL Profile.
*
* Copyright (c) 2008, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from  Freescale Semiconductor.
*
******************************************************************************/

#include "EmbeddedTypes.h"
#include "FSLProfileInterface.h"
#include "FSLProfileConf.h"
#include "ApplicationConf.h"
#include "NwkGlobals.h"
#include "ApplicationFunctionalityDefines.h"

/******************************************************************************
*******************************************************************************
* Private Macros
*******************************************************************************
******************************************************************************/

/******************************************************************************
*******************************************************************************
* Public memory declarations
*******************************************************************************
******************************************************************************/

#if gFSLProfileTask_d
 /* The Task Id for FSL Profile */
 tsTaskID_t gFSLProfileTaskID_c;  
#endif


#if gFSLProfileFragTxOrig_d || gFSLProfileFragTxRecip_d
    
    CONST uint16_t fragTxRxBufferLength_c = gFSLProfileFragTxRxBufferLength_c;
    
    uint8_t fragTxRxDataBuffer[gFSLProfileFragTxRxBufferLength_c];
    
#endif /* gFSLProfileFragTxOrig_d  || gFSLProfileFragTxRecip_d */


/* Image load procent 0-100%, 101 process didn't started */
#if gFSLProfileOtapClient_d
/* Image load percentage 0-100% 
   Value 101 means that no over the air download process is taking place */
uint8_t gOtapClientDownloadImageStatus = 101;
/* Number of RF4CE frame retries the client will perform in case no
response comes back from the server */
CONST uint8_t  gOtapClientMaxRetries	  = gOtapClientMaxRetries_c;
/* Amount of time the client wait for server to respond to its requests, before
starting to retry the frame.  */
CONST uint16_t gOtapClientWaitRespTimeout = gProfileOtapClientWaitRespTimeout_c;
#endif



/******************************************************************************
*******************************************************************************
* Private Macros
*******************************************************************************
******************************************************************************/
/****************************************************************************/
